<?php
require_once "../Api.php";
require "./get/getStorage.php";
require "./put/updateStorage.php";
require "./post/createStorage.php";
require "./patch/changeStorage.php";
require "./delete/deleteStorage.php";

class storageApi extends Api
{
   public $apiName = "storage";

   /**
    * Метод GET
    * Вывод списка всех записей
    * http://ДОМЕН/Storage
    * @return string
    */
   public function getAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "storage":
               return getStorageInfo();
               break;
            case "long":
               return getLongStorage();
               break;
            case "disks":
               $sock = Login();
               $getterDiskInfo = ParamGet($sock, "DiskInfo");
               $array = getDiskInfo($getterDiskInfo);
               socket_close($sock);
               return $array;
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод POST
    * Создание новой записи
    * http://ДОМЕН/Storage
    * @return string
    */
   public function createAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "replacement":
               replacementDisk();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PATCH
    * Создание новой записи
    * http://ДОМЕН/Storage
    * @return string
    */
   public function changeAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "storage":
               changeStorageSettings();
               break;
            case "long-storage":
               changeLongStorage();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PUT
    * Обновление отдельной записи (по ее id)
    * http://ДОМЕН/Storage
    * @return string
    */
   public function updateAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    newConnection($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }

   /**
    * Метод DELETE
    * Удаление отдельной записи (по ее id)
    * http://ДОМЕН/Storage
    * @return string
    */
   public function deleteAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    resetCamera($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }
}
